'use strict';

function isString(variable) {
	return typeof variable === 'string' || variable instanceof String;
}

function isNumber(variable) {
	return typeof variable === 'number' || variable instanceof Number;
}

function isBoolean(variable) {
	return typeof variable === 'boolean';
}

function isArray(variable) {
	return Array.isArray(variable);
}

function isFunction(variable) {
	return typeof variable === 'function';
}

function isObject(variable) {
	return variable !== null && typeof variable === 'object';
}

function isNull(variable) {
	return variable === null;
}

function isUndefined(variable) {
	return variable === undefined;
}

function pack() {
	var result = {};

	for (var i = 0, l = arguments.length; i < l; i++) {
		var obj = arguments[i];

		if (obj) {
			for (var key in obj) {
				if (obj.hasOwnProperty(key)) {
					result[key] = obj[key];
				}
			}
		}
	}

	return result;
}

function offsetVector(vector, x, y) {
	switch (vector.type) {
		case 'ellipse':
		case 'rect':
			vector.x += x;
			vector.y += y;
			break;
		case 'line':
			vector.x1 += x;
			vector.x2 += x;
			vector.y1 += y;
			vector.y2 += y;
			break;
		case 'polyline':
			for (var i = 0, l = vector.points.length; i < l; i++) {
				vector.points[i].x += x;
				vector.points[i].y += y;
			}
			break;
	}
}

function fontStringify(key, val) {
	if (key === 'font') {
		return 'font';
	}
	return val;
}

module.exports = {
	isString: isString,
	isNumber: isNumber,
	isBoolean: isBoolean,
	isArray: isArray,
	isFunction: isFunction,
	isObject: isObject,
	isNull: isNull,
	isUndefined: isUndefined,
	pack: pack,
	fontStringify: fontStringify,
	offsetVector: offsetVector
};
